<?php
/* --------------------------------------------------------------
 UserPreferences.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application\ValueObjects;

use Gambio\Admin\UserConfiguration\Interfaces\UserId as UserConfigurationId;
use Gambio\Core\Permission\UserId as PermissionUserId;

/**
 * Class UserPreferences
 * @package Gambio\Core\Application\ValueObjects
 */
class UserPreferences implements UserConfigurationId, PermissionUserId
{
    /**
     * @var int|null
     */
    private $customerId;
    
    /**
     * @var int
     */
    private $languageId;
    
    
    /**
     * UserPreferences constructor.
     *
     * @param int|null $customerId
     * @param int      $languageId
     */
    public function __construct(?int $customerId, int $languageId)
    {
        $this->customerId = $customerId;
        $this->languageId = $languageId;
    }
    
    
    /**
     * @return int
     */
    public function customerId(): ?int
    {
        return $this->customerId;
    }
    
    
    /**
     * @return bool
     */
    public function isCustomer(): bool
    {
        return null !== $this->customerId;
    }
    
    
    /**
     * @return int
     */
    public function languageId(): int
    {
        return $this->languageId;
    }
    
    
    /**
     * @inheritDoc
     */
    public function userId(): int
    {
        return $this->customerId;
    }
}